/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.util;

import com.taobao.hsf.model.ApplicationModel;
import com.taobao.hsf.model.ConsumerServiceModel;
import com.taobao.hsf.model.ProviderServiceModel;
import com.taobao.hsf.model.metadata.ServiceMetadata;
import com.taobao.hsf.util.ThreadLocalUtil;

public class HSFUtil {
    public static String getGroupAsProvider(String servicename) {
        ServiceMetadata metadata = HSFUtil.findProviderModel(servicename);
        return metadata.getGroup();
    }

    public static String getDefaultGroupAsProvider(String servicename) {
        ServiceMetadata metadata = HSFUtil.findProviderModel(servicename);
        return metadata.getDefaultGroup();
    }

    public static String getGroupAsConsumer(String servicename) {
        ServiceMetadata metadata = HSFUtil.findConsumerModel(servicename);
        return metadata.getGroup();
    }

    public static String getDefaultGroupAsConsumer(String servicename) {
        ServiceMetadata metadata = HSFUtil.findConsumerModel(servicename);
        return metadata.getDefaultGroup();
    }

    public static void setTargetUnit(String name) {
        ThreadLocalUtil.set("target-unit", name);
    }

    private static ServiceMetadata findProviderModel(String servicename) {
        ProviderServiceModel providedServiceModel = ApplicationModel.instance().getProvidedServiceModel(servicename);
        if (providedServiceModel == null) {
            throw new IllegalArgumentException(servicename + " is not provided");
        }
        ServiceMetadata metadata = providedServiceModel.getMetadata();
        return metadata;
    }

    private static ServiceMetadata findConsumerModel(String servicename) {
        ConsumerServiceModel consumedServiceModel = ApplicationModel.instance().getConsumedServiceModel(servicename);
        if (consumedServiceModel == null) {
            throw new IllegalArgumentException(servicename + " is not consumed");
        }
        ServiceMetadata metadata = consumedServiceModel.getMetadata();
        return metadata;
    }
}

