/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.util;

import com.taobao.hsf.logger.LoggerInit;
import com.taobao.middleware.logger.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import sun.net.util.IPAddressUtil;

public class InetAddressUtil {
    private static final Logger LOGGER = LoggerInit.LOGGER;
    private static final String MACHINEROOM_SETTINGS = "machineroom_settings.properties";
    private static final String INETADDRESS_SETTINGS = "inetaddress_settings.properties";
    private static final String KEY_DISABLED_IP_SEGMENTS = "disabled_ip_segments";
    private static Properties machineRoomSettings;
    private static List<String> disabledSegments;
    private static String IP;

    public static String getIP() {
        if (IP == null) {
            IP = InetAddressUtil.getInetAddress();
        }
        return IP;
    }

    public static boolean isInTheSameSegment(String serviceAddress, int masked) {
        if (serviceAddress == null || serviceAddress.length() == 0) {
            return false;
        }
        String anotherIP = serviceAddress;
        int index = anotherIP.indexOf(":");
        if (index > 0) {
            anotherIP = anotherIP.substring(0, index);
        }
        return InetAddressUtil.isInTheSameSegment(InetAddressUtil.getIP(), anotherIP, masked, true);
    }

    public static boolean isInTheSameSegment(String IP, String anotherIP, int masked, boolean enableSettings) {
        if (IP == null || anotherIP == null) {
            throw new NullPointerException("\u53c2\u6570IP\u548canotherIP\u4e0d\u80fd\u4e3anull");
        }
        if (enableSettings && machineRoomSettings != null && !machineRoomSettings.isEmpty()) {
            String local = machineRoomSettings.getProperty(IP);
            String another = machineRoomSettings.getProperty(anotherIP);
            return local == null ? another == null : local.equals(another);
        }
        if (masked < 0 || masked > 4) {
            throw new IllegalArgumentException("\u63a9\u7801\u6bb5\u6570\u5fc5\u987b\u5728[1,4]\u7684\u8303\u56f4\u5185");
        }
        String[] groups = IP.split("\\.");
        if (groups.length != 4) {
            return true;
        }
        String[] anotherGroups = anotherIP.split("\\.");
        if (anotherGroups.length != 4) {
            return false;
        }
        for (int i = 0; i < masked; ++i) {
            if (groups[i].equals(anotherGroups[i])) continue;
            return false;
        }
        return true;
    }

    private static String getInetAddress() {
        try {
            String ip = System.getProperty("hsf.server.ip");
            if (StringUtils.isNotEmpty((String)ip)) {
                return ip;
            }
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            ArrayList<InetAddress> addressList = new ArrayList<InetAddress>();
            while (interfaces.hasMoreElements()) {
                NetworkInterface ni = interfaces.nextElement();
                Enumeration<InetAddress> addresses = ni.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    if (address.isLoopbackAddress() || address.getHostAddress().indexOf(":") != -1 || !InetAddressUtil.notDisabled(address)) continue;
                    addressList.add(address);
                }
            }
            if (addressList.size() == 1) {
                return ((InetAddress)addressList.get(0)).getHostAddress();
            }
            if (addressList.size() > 1) {
                for (InetAddress each : addressList) {
                    if (!InetAddressUtil.internalIp(each.getAddress())) continue;
                    return each.getHostAddress();
                }
            }
            LOGGER.warn("[InetAddressUtil] Can not get the server IP address.");
            return null;
        }
        catch (Throwable t) {
            LOGGER.warn("[InetAddressUtil] Get the server IP address failed.", new Object[]{t});
            return null;
        }
    }

    public static boolean internalIp(String ip) {
        byte[] addr = IPAddressUtil.textToNumericFormatV4(ip);
        return InetAddressUtil.internalIp(addr);
    }

    public static boolean internalIp(byte[] addr) {
        byte b0 = addr[0];
        byte b1 = addr[1];
        int SECTION_1 = 10;
        int SECTION_2 = -84;
        int SECTION_3 = 16;
        int SECTION_4 = 31;
        int SECTION_5 = -64;
        int SECTION_6 = -88;
        switch (b0) {
            case 10: {
                return true;
            }
            case -84: {
                if (b1 >= 16 && b1 <= 31) {
                    return true;
                }
            }
            case -64: {
                switch (b1) {
                    case -88: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static boolean notDisabled(InetAddress address) {
        if (disabledSegments.isEmpty()) {
            return true;
        }
        for (String segment : disabledSegments) {
            if (!address.getHostAddress().startsWith(segment)) continue;
            return false;
        }
        return true;
    }

    static {
        disabledSegments = new ArrayList<String>();
        InputStream is = null;
        try {
            is = InetAddressUtil.class.getClassLoader().getResourceAsStream(MACHINEROOM_SETTINGS);
            if (is != null) {
                machineRoomSettings = new Properties();
                machineRoomSettings.load(is);
            }
        }
        catch (IOException e) {
            LOGGER.warn("[InetAddressUtil] Initailized failed: error occurs on reading machineroom_settings.properties.", new Object[]{e});
            machineRoomSettings.clear();
        }
        try {
            is = InetAddressUtil.class.getClassLoader().getResourceAsStream(INETADDRESS_SETTINGS);
            if (is != null) {
                Properties props = new Properties();
                props.load(is);
                String value = (String)props.get(KEY_DISABLED_IP_SEGMENTS);
                if (value != null && value.length() > 0) {
                    String[] values;
                    for (String s : values = value.split(",")) {
                        if (s == null || s.length() <= 0) continue;
                        disabledSegments.add(s);
                    }
                }
            }
        }
        catch (IOException e) {
            LOGGER.warn("[InetAddressUtil] Initailized failed: error occurs on reading inetaddress_settings.properties.", new Object[]{e});
            disabledSegments.clear();
        }
        IP = null;
    }
}

