/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sojo.core;

import net.sf.sojo.core.ComplexConversion;
import net.sf.sojo.core.Conversion;
import net.sf.sojo.core.ConversionContext;
import net.sf.sojo.core.ConversionException;
import net.sf.sojo.core.ConversionHandler;
import net.sf.sojo.core.ConverterInterceptor;
import net.sf.sojo.core.ConverterInterceptorHandler;
import net.sf.sojo.core.IConverter;
import net.sf.sojo.core.IConverterExtension;
import net.sf.sojo.core.IterateableConversion;
import net.sf.sojo.core.NonCriticalExceptionHandler;
import net.sf.sojo.core.SimpleConversion;
import net.sf.sojo.core.UniqueIdGenerator;
import net.sf.sojo.core.filter.ClassPropertyFilterHandler;
import net.sf.sojo.core.reflect.ReflectionHelper;

public final class Converter
implements IConverter {
    private ConverterInterceptorHandler interceptorHandler = new ConverterInterceptorHandler();
    private ConversionHandler conversionHandler = new ConversionHandler();
    private UniqueIdGenerator uniqueIdGenerator = new UniqueIdGenerator();
    private boolean throwExceptionIfNoConversionFind = false;
    private int numberOfRecursion = -1;
    protected ClassPropertyFilterHandler classPropertyFilterHandler = null;
    static /* synthetic */ Class class$0;

    public void setThrowExceptionIfNoConversionFind(boolean pvThrowExceptionIfNoConversionFind) {
        this.throwExceptionIfNoConversionFind = pvThrowExceptionIfNoConversionFind;
    }

    public boolean getThrowExceptionIfNoConversionFind() {
        return this.throwExceptionIfNoConversionFind;
    }

    public void setConversionHandler(ConversionHandler pvConversionHandler) {
        this.conversionHandler = pvConversionHandler;
    }

    public ConversionHandler getConversionHandler() {
        return this.conversionHandler;
    }

    public Conversion replaceConversion(Conversion pvConversion) {
        return this.conversionHandler.replaceConversion(pvConversion);
    }

    public Conversion replaceAllConversion(Conversion pvConversion) {
        return this.conversionHandler.replaceAllConversion(pvConversion);
    }

    public void addConversion(Conversion pvConversion) {
        this.conversionHandler.addConversion(pvConversion);
    }

    public void clearConversion() {
        this.conversionHandler.clear();
    }

    public Conversion removeConversion(Conversion pvConversion) {
        return this.conversionHandler.removeConversion(pvConversion);
    }

    public void addConverterInterceptor(ConverterInterceptor pvConverterInterceptor) {
        this.interceptorHandler.addConverterInterceptor(pvConverterInterceptor);
    }

    public void removeConverterInterceptor(ConverterInterceptor pvSearchInterceptor) {
        this.interceptorHandler.removeConverterInterceptor(pvSearchInterceptor);
    }

    public ConverterInterceptor getConverterInterceptorByPosition(int pvPosition) {
        return this.interceptorHandler.getConverterInterceptorByPosition(pvPosition);
    }

    public int getConverterInterceptorSize() {
        return this.interceptorHandler.size();
    }

    public void clearConverterInterceptorSize() {
        this.interceptorHandler.clear();
    }

    public int getNumberOfRecursion() {
        return this.numberOfRecursion;
    }

    public void setClassPropertyFilterHandler(ClassPropertyFilterHandler pvClassPropertyFilterHandler) {
        this.classPropertyFilterHandler = pvClassPropertyFilterHandler;
    }

    public ClassPropertyFilterHandler getClassPropertyFilterHandler() {
        return this.classPropertyFilterHandler;
    }

    public Object convert(Object pvObject) {
        return this.convert(pvObject, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object convert(Object pvObject, Class pvToType) {
        Object lvResult = pvObject;
        lvResult = this.interceptorHandler.fireBeforeConvert(lvResult, pvToType);
        try {
            try {
                lvResult = this.convertInternal(lvResult, pvToType);
            }
            catch (Exception e) {
                this.interceptorHandler.fireOnError(e);
                if (!(e instanceof ConversionException)) throw new ConversionException(e);
                throw (ConversionException)e;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.numberOfRecursion = -1;
            this.uniqueIdGenerator.clear();
            lvResult = this.interceptorHandler.fireAfterConvert(lvResult, pvToType);
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.numberOfRecursion = -1;
            this.uniqueIdGenerator.clear();
            return this.interceptorHandler.fireAfterConvert(lvResult, pvToType);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object convertInternal(Object pvObject, Class pvToType) {
        Object lvReturn = pvObject;
        Conversion lvConversion = this.conversionHandler.getConversion(lvReturn, pvToType);
        ++this.numberOfRecursion;
        ConversionContext lvContext = new ConversionContext(this.numberOfRecursion, lvConversion, lvReturn);
        this.interceptorHandler.fireBeforeConvertRecursion(lvContext);
        try {
            if (lvConversion != null && !lvContext.cancelConvert) {
                lvReturn = lvConversion.getConverterInterceptorHandler().fireBeforeConvert(lvReturn, pvToType);
                if (lvConversion instanceof SimpleConversion) {
                    SimpleConversion lvSimpleConversion = (SimpleConversion)lvConversion;
                    lvReturn = lvSimpleConversion.convert(lvReturn, pvToType);
                } else if (lvConversion instanceof IterateableConversion) {
                    IterateableConversion lvIterateableConversion = (IterateableConversion)lvConversion;
                    lvIterateableConversion.setClassPropertyFilterHandler(this.classPropertyFilterHandler);
                    lvReturn = lvIterateableConversion.convert(lvReturn, pvToType, new InternalRecursiveConverterExtension(this));
                } else if (lvConversion instanceof ComplexConversion) {
                    ComplexConversion lvComplexConversion = (ComplexConversion)lvConversion;
                    lvComplexConversion.setClassPropertyFilterHandler(this.classPropertyFilterHandler);
                    lvReturn = lvComplexConversion.convert(lvReturn, pvToType, new InternalRecursiveConverterExtension(this));
                } else {
                    this.handleException("Not supported conversion type: " + lvConversion + " and object: " + lvReturn);
                }
                lvReturn = lvConversion.getConverterInterceptorHandler().fireAfterConvert(lvReturn, pvToType);
            } else {
                this.handleException("No conversion find for object: " + lvReturn + " from type: " + (lvReturn == null ? "NoClassAvail" : lvReturn.getClass().getName()));
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            lvContext.value = lvReturn;
            this.interceptorHandler.fireAfterConvertRecursion(lvContext);
            throw throwable;
        }
        {
            Object var7_11 = null;
            lvContext.value = lvReturn;
            this.interceptorHandler.fireAfterConvertRecursion(lvContext);
            return lvReturn;
        }
    }

    private void handleException(String pvMessage) {
        if (this.getThrowExceptionIfNoConversionFind()) {
            throw new ConversionException(pvMessage);
        }
        if (NonCriticalExceptionHandler.isNonCriticalExceptionHandlerEnabled()) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("net.sf.sojo.core.Converter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            NonCriticalExceptionHandler.handleException(clazz, pvMessage);
        }
    }

    private static class InternalRecursiveConverterExtension
    implements IConverterExtension {
        protected Converter converter = null;

        public InternalRecursiveConverterExtension(Converter pvConverter) {
            this.converter = pvConverter;
        }

        public Object convert(Object pvObject) {
            return this.convert(pvObject, null);
        }

        public Object convert(Object pvObject, Class pvToType) {
            Object lvReturn = null;
            if (ReflectionHelper.isSimpleType(pvObject)) {
                lvReturn = this.converter.convertInternal(pvObject, pvToType);
            } else if (this.converter.uniqueIdGenerator.isKnownObject(pvObject)) {
                String lvId = this.converter.uniqueIdGenerator.getUniqueId(pvObject);
                lvReturn = UniqueIdGenerator.getUniqueIdStringByNumber(lvId);
            } else {
                lvReturn = this.converter.convertInternal(pvObject, pvToType);
            }
            return lvReturn;
        }

        public final String getUniqueId(Object pvObject) {
            return this.converter.uniqueIdGenerator.getUniqueId(pvObject);
        }

        public Object addObject(String pvUniqueId, Object pvObject) {
            return this.converter.uniqueIdGenerator.addObject(pvUniqueId, pvObject);
        }

        public Object getObjectByUniqueId(String pvUniqueId) {
            return this.converter.uniqueIdGenerator.getObjectByUniqueId(pvUniqueId);
        }
    }
}

