/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sojo.core.filter;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class ClassPropertyFilter {
    private Class filterClass = null;
    private List propertyList = new ArrayList();
    private boolean support4AddClassProperty = false;

    public ClassPropertyFilter() {
    }

    public ClassPropertyFilter(Class pvClass) {
        this.setFilterClass(pvClass);
    }

    public ClassPropertyFilter(Class pvClass, String[] pvProperties) {
        this.setFilterClass(pvClass);
        this.addProperties(pvProperties);
    }

    public Class getFilterClass() {
        return this.filterClass;
    }

    private void setFilterClass(Class pvClass) {
        this.filterClass = pvClass;
    }

    public void setSupport4AddClassProperty(boolean pvSupport4AddClassProperty) {
        this.support4AddClassProperty = pvSupport4AddClassProperty;
    }

    public boolean getSupport4AddClassProperty() {
        return this.support4AddClassProperty;
    }

    public ClassPropertyFilter addProperties(String[] pvProperties) {
        if (pvProperties != null) {
            int i = 0;
            while (i < pvProperties.length) {
                this.addProperty(pvProperties[i]);
                ++i;
            }
        }
        return this;
    }

    public ClassPropertyFilter addProperty(String pvProperty) {
        if (!"class".equals(pvProperty) || this.getSupport4AddClassProperty()) {
            this.propertyList.add(pvProperty);
        }
        return this;
    }

    public ClassPropertyFilter removeProperty(String pvProperty) {
        int i = 0;
        while (i < this.propertyList.size()) {
            if (this.propertyList.get(i).equals(pvProperty)) {
                this.propertyList.remove(i);
            }
            ++i;
        }
        return this;
    }

    public ClassPropertyFilter removeProperties(String[] pvProperty) {
        if (pvProperty != null) {
            int i = 0;
            while (i < pvProperty.length) {
                this.removeProperty(pvProperty[i]);
                ++i;
            }
        }
        return this;
    }

    public boolean isKnownProperty(String pvProperty) {
        int i = 0;
        while (i < this.propertyList.size()) {
            if (this.propertyList.get(i).equals(pvProperty)) {
                return true;
            }
            boolean b = Pattern.matches((String)this.propertyList.get(i), pvProperty);
            if (b) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int getPropertySize() {
        return this.propertyList.size();
    }

    public String[] getAllProperties() {
        return this.propertyList.toArray(new String[this.propertyList.size()]);
    }
}

