/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sojo.core.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import net.sf.sojo.core.NonCriticalExceptionHandler;
import net.sf.sojo.core.reflect.AccessiblePrivilegedAction;
import net.sf.sojo.core.reflect.ClassPropertiesCache;
import net.sf.sojo.core.reflect.ReflectionHelper;
import net.sf.sojo.util.Util;

public final class ReflectionMethodHelper {
    public static final int GET_METHOD = 1;
    public static final int SET_METHOD = 2;
    protected static final ClassPropertiesCache classPropertiesCacheGetter = new ClassPropertiesCache();
    protected static final ClassPropertiesCache classPropertiesCacheSetter = new ClassPropertiesCache();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected ReflectionMethodHelper() {
    }

    public static Map getAllGetterMethod(Class pvClass) {
        return ReflectionMethodHelper.getAllGetterAndSetterMethod(pvClass, 1);
    }

    public static Map getAllSetterMethod(Class pvClass) {
        return ReflectionMethodHelper.getAllGetterAndSetterMethod(pvClass, 2);
    }

    public static Map getAllNotEqualsGetterAndSetterAndRemoveThisProperties(Map pvGetterMap, Map pvSetterMap) {
        TreeMap lvMap = new TreeMap();
        Iterator it = new ArrayList(pvGetterMap.keySet()).iterator();
        lvMap.put("class", pvGetterMap.get("class"));
        while (it.hasNext()) {
            Object lvGetterProp = it.next();
            if (!pvSetterMap.containsKey(lvGetterProp)) continue;
            lvMap.put((String)lvGetterProp, pvGetterMap.get(lvGetterProp));
        }
        return Collections.unmodifiableMap(lvMap);
    }

    public static Map getAllGetterMethodWithCache(Class pvClass, String[] pvFilter) {
        Map lvGetterMap = classPropertiesCacheGetter.getClassPropertiesMapByClass(pvClass);
        if (lvGetterMap == null) {
            lvGetterMap = ReflectionMethodHelper.getAllGetterMethod(pvClass);
            Map lvSetterMap = ReflectionMethodHelper.getAllSetterMethodWithCache(pvClass, pvFilter);
            lvGetterMap = ReflectionMethodHelper.getAllNotEqualsGetterAndSetterAndRemoveThisProperties(lvGetterMap, lvSetterMap);
            classPropertiesCacheGetter.addClassPropertiesMap(pvClass, lvGetterMap);
        }
        return lvGetterMap;
    }

    public static Map getAllSetterMethodWithCache(Class pvClass, String[] pvFilter) {
        Map lvMap = classPropertiesCacheSetter.getClassPropertiesMapByClass(pvClass);
        if (lvMap == null) {
            lvMap = ReflectionMethodHelper.getAllSetterMethod(pvClass);
            classPropertiesCacheSetter.addClassPropertiesMap(pvClass, lvMap);
        }
        lvMap = Util.filterMapByKeys(lvMap, pvFilter);
        return lvMap;
    }

    public static Method[] getAllMethodsByClass(Class pvClass) {
        return ReflectionMethodHelper.getAllMethodsByClassIntern(pvClass, new Hashtable()).toArray(new Method[0]);
    }

    private static Collection getAllMethodsByClassIntern(Class pvClass, Map pvMethodsMap) {
        ReflectionMethodHelper.putAllMethodsIntern(pvClass.getMethods(), pvMethodsMap);
        ReflectionMethodHelper.putAllMethodsIntern(pvClass.getDeclaredMethods(), pvMethodsMap);
        Class clazz = pvClass.getSuperclass();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!clazz.equals(clazz2)) {
            ReflectionMethodHelper.getAllMethodsByClassIntern(pvClass.getSuperclass(), pvMethodsMap);
        }
        return pvMethodsMap.values();
    }

    private static void putAllMethodsIntern(Method[] pvAllMethods, Map pvMethodsMap) {
        int i = 0;
        while (i < pvAllMethods.length) {
            String lvMethodName = pvAllMethods[i].getName();
            if (lvMethodName.startsWith("set") || lvMethodName.startsWith("get")) {
                pvMethodsMap.put(pvAllMethods[i], pvAllMethods[i]);
            }
            ++i;
        }
    }

    public static Map getAllGetterAndSetterMethod(Class pvClass, int pvMethodType) {
        Method[] lvAllMethods = ReflectionMethodHelper.getAllMethodsByClass(pvClass);
        TreeMap<String, Object> lvGetterOrSetter = new TreeMap<String, Object>();
        int i = 0;
        while (i < lvAllMethods.length) {
            Method lvMethod = null;
            String lvPropName = lvAllMethods[i].getName();
            switch (pvMethodType) {
                case 1: {
                    if (!lvPropName.startsWith("get")) break;
                    lvMethod = lvAllMethods[i];
                    if (!NonCriticalExceptionHandler.isNonCriticalExceptionHandlerEnabled() || ReflectionMethodHelper.isMethodSetterAndGetterCompliant(lvMethod.getReturnType())) break;
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("net.sf.sojo.core.reflect.ReflectionMethodHelper");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    NonCriticalExceptionHandler.handleException(clazz, "The method: " + lvMethod + " is not valid getter-method (bean complaint)");
                    break;
                }
                case 2: {
                    if (!lvPropName.startsWith("set")) break;
                    lvMethod = lvAllMethods[i];
                    if (!NonCriticalExceptionHandler.isNonCriticalExceptionHandlerEnabled() || lvMethod.getParameterTypes().length == 1 || !ReflectionMethodHelper.isMethodSetterAndGetterCompliant(lvMethod.getParameterTypes()[0])) break;
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("net.sf.sojo.core.reflect.ReflectionMethodHelper");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    NonCriticalExceptionHandler.handleException(clazz, "The method: " + lvMethod + " is not valid setter-method (bean complaint)");
                    break;
                }
            }
            if (lvMethod != null) {
                AccessController.doPrivileged(new AccessiblePrivilegedAction(lvMethod));
                lvPropName = lvPropName.substring(3);
                if (lvPropName.length() > 0) {
                    if ((lvPropName = String.valueOf(lvPropName.substring(0, 1).toLowerCase()) + lvPropName.substring(1)).equals("class")) {
                        lvGetterOrSetter.put(lvPropName, pvClass.getName());
                    } else {
                        lvGetterOrSetter.put(lvPropName, lvMethod);
                    }
                } else if (NonCriticalExceptionHandler.isNonCriticalExceptionHandlerEnabled()) {
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("net.sf.sojo.core.reflect.ReflectionMethodHelper");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    NonCriticalExceptionHandler.handleException(clazz, "Invalid Property-Name: '" + lvAllMethods[i].getName() + "' (Valid Property-Name is: set[name] or get[name], eg. setYear and getYear).");
                }
            }
            ++i;
        }
        return Collections.unmodifiableMap(lvGetterOrSetter);
    }

    public static boolean isMethodSetterAndGetterCompliant(Class pvClass) {
        boolean lvReturn = false;
        if (ReflectionHelper.isSimpleType(pvClass)) {
            lvReturn = true;
        } else if (pvClass.isInterface()) {
            lvReturn = true;
        } else if (pvClass.getName().startsWith("java.util.")) {
            lvReturn = false;
        } else if (pvClass.getConstructors().length > 0) {
            Constructor<?>[] lvConstructor = pvClass.getConstructors();
            int i = 0;
            while (i < lvConstructor.length) {
                if (lvConstructor[i].getParameterTypes().length == 0) {
                    lvReturn = true;
                    break;
                }
                ++i;
            }
        }
        return lvReturn;
    }
}

