/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sojo.interchange.csv;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.sf.sojo.core.ConversionException;
import net.sf.sojo.core.conversion.Simple2SimpleConversion;
import net.sf.sojo.core.reflect.ReflectionHelper;
import net.sf.sojo.interchange.AbstractSerializer;
import net.sf.sojo.interchange.csv.CsvParser;
import net.sf.sojo.interchange.csv.CsvParserException;
import net.sf.sojo.interchange.csv.CsvWalkerInterceptor;
import net.sf.sojo.util.Table;

public class CsvSerializer
extends AbstractSerializer {
    private CsvWalkerInterceptor csvWalkerInterceptor = new CsvWalkerInterceptor();
    private CsvParser csvParser = new CsvParser();
    private boolean ignoreNullValues = false;
    static /* synthetic */ Class class$0;

    public CsvSerializer() {
        this.setWithSimpleKeyMapper(false);
        this.walker.addInterceptor(this.csvWalkerInterceptor);
        this.setIgnoreNullValues(false);
    }

    public void setIgnoreNullValues(boolean pvIgnoreNullValues) {
        this.ignoreNullValues = pvIgnoreNullValues;
        this.walker.setIgnoreNullValues(this.ignoreNullValues);
    }

    public boolean getIgnoreNullValues() {
        return this.ignoreNullValues;
    }

    public void setNullValue(String pvNullValue) {
        this.csvWalkerInterceptor.setNullValue(pvNullValue);
    }

    public String getNullValue() {
        return this.csvWalkerInterceptor.getNullValue();
    }

    public void setWithPropertyNamesInFirstLine(boolean pvWithPropertyNamesInFirstLine) {
        this.csvWalkerInterceptor.setWithColumnNames(pvWithPropertyNamesInFirstLine);
    }

    public boolean getWithPropertyNamesInFirstLine() {
        return this.csvWalkerInterceptor.getWithColumnNames();
    }

    public Object serialize(Object pvRootObject) {
        this.csvWalkerInterceptor.setWrapSimpleValueAsList(false);
        if (pvRootObject == null) {
            return null;
        }
        ArrayList o = pvRootObject;
        if (!(o instanceof Collection) && !o.getClass().isArray()) {
            this.csvWalkerInterceptor.setWrapSimpleValueAsList(true);
            ArrayList l = new ArrayList();
            l.add(pvRootObject);
            o = l;
        }
        this.walker.walk(o);
        return this.csvWalkerInterceptor.getCsvString();
    }

    public Object deserialize(Object pvSourceObject, Class pvRootClass) {
        Object o = null;
        if (pvSourceObject == null) {
            o = null;
        } else {
            if (!(pvSourceObject instanceof String)) {
                throw new CsvParserException("Only objects from type String can deserialize: " + pvSourceObject.getClass().getName());
            }
            Table lvTable = this.csvParser.parse(pvSourceObject.toString());
            List lvRows = lvTable.getRows();
            if (lvRows.size() == 0) {
                o = this.getNullValue();
            } else if (lvRows.size() == 1) {
                List lvColumn = (List)lvRows.get(0);
                o = lvColumn.size() == 1 ? lvColumn.get(0) : lvColumn;
                try {
                    o = this.convertString2Object(o, pvRootClass);
                }
                catch (ConversionException e) {
                    throw new CsvParserException("Can't convert object: " + o + " (" + o.getClass().getName() + ") to class: " + pvRootClass);
                }
            } else if (this.getWithPropertyNamesInFirstLine()) {
                List lvObjectList = this.convertSimple2ObjectList(lvRows, pvRootClass);
                o = lvObjectList;
                if (pvRootClass != null && pvRootClass.isArray()) {
                    Object[] objArr = (Object[])Array.newInstance(pvRootClass.getComponentType(), lvObjectList.size());
                    int i = 0;
                    while (i < lvObjectList.size()) {
                        objArr[i] = lvObjectList.get(i);
                        ++i;
                    }
                    o = objArr;
                }
            } else {
                o = lvRows;
            }
        }
        return o;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object convertString2Object(Object pvSourceObject, Class pvRootClass) {
        Object o = pvSourceObject;
        if (pvRootClass == null) return o;
        if (!ReflectionHelper.isSimpleType(pvRootClass)) {
            return this.getObjectUtil().makeComplex(pvSourceObject, pvRootClass);
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz = class$0 = clazz2;
        }
        Simple2SimpleConversion lvConversion = new Simple2SimpleConversion(clazz, pvRootClass);
        try {
            this.getObjectUtil().getConverter().addConversion(lvConversion);
            o = this.getObjectUtil().makeComplex(pvSourceObject, pvRootClass);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.getObjectUtil().getConverter().removeConversion(lvConversion);
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.getObjectUtil().getConverter().removeConversion(lvConversion);
            return o;
        }
    }

    public List convertSimple2ObjectList(List pvNamedList, Class pvRootClass) {
        int lvRowSize = pvNamedList.size();
        ArrayList<Object> lvReturn = new ArrayList<Object>(lvRowSize - 1);
        List lvColumnNames = (List)pvNamedList.get(0);
        int lvColumnNamesSize = lvColumnNames.size();
        int i = 1;
        while (i < lvRowSize) {
            HashMap lvNameValueMap = new HashMap();
            List lvColumnValues = (List)pvNamedList.get(i);
            int j = 0;
            while (j < lvColumnNamesSize) {
                Object lvName = lvColumnNames.get(j);
                Object lvValue = lvColumnValues.get(j);
                if (lvValue.equals(this.getNullValue())) {
                    lvValue = null;
                }
                lvNameValueMap.put(lvName, lvValue);
                ++j;
            }
            Class<?> lvRootClass = pvRootClass != null && pvRootClass.isArray() ? pvRootClass.getComponentType() : pvRootClass;
            Object o = this.getObjectUtil().makeComplex(lvNameValueMap, lvRootClass);
            lvReturn.add(o);
            ++i;
        }
        return lvReturn;
    }
}

