/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sojo.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Table {
    public static final String DEFAULT_DELIMITER = ",";
    private static final long serialVersionUID = 936013998377909481L;
    private List rows = new ArrayList();
    private List currentColumn = null;
    private List columnNames = new ArrayList();
    private boolean withColumnNames = true;
    private String delimiter = ",";
    private int numberOfColumns = -1;

    public Table() {
        this.newRow();
    }

    public void setWithColumnNames(boolean pvWithColumnNames) {
        this.withColumnNames = pvWithColumnNames;
    }

    public boolean getWithColumnNames() {
        return this.withColumnNames;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String pvDelimiter) {
        this.delimiter = pvDelimiter;
    }

    public void addValue2CurrentRow(Object pvValue) {
        this.addValue2CurrentRow(null, pvValue);
    }

    public void addValue2CurrentRow(String pvColumnName, Object pvValue) {
        this.currentColumn.add(pvValue);
        int lvCurrentColumnNumber = this.currentColumn.size();
        if (this.numberOfColumns < lvCurrentColumnNumber) {
            this.numberOfColumns = lvCurrentColumnNumber;
        }
        if (this.getWithColumnNames() && this.rows.size() == 1) {
            String lvColumnName = pvColumnName;
            if (lvColumnName == null && pvValue != null) {
                lvColumnName = pvValue.toString();
            }
            this.columnNames.add(lvColumnName);
        }
    }

    public void addValue2NewRow(Object pvValue) {
        this.newRow();
        this.addValue2CurrentRow(pvValue);
    }

    public int newRow() {
        this.currentColumn = new ArrayList();
        this.rows.add(this.currentColumn);
        return this.rows.size();
    }

    public void clear() {
        this.columnNames.clear();
        this.rows.clear();
    }

    public int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    public int getCurrentColumnNumber() {
        return this.currentColumn.size() - 1;
    }

    public int getCurrentRowNumber() {
        return this.rows.size();
    }

    public List getRows() {
        return this.rows;
    }

    public List getLastRow() {
        return (List)this.rows.get(this.rows.size() - 1);
    }

    public void removeRow(int pvPos) {
        this.rows.remove(pvPos);
    }

    public String getRowsWithColumnsAsString() {
        StringBuffer sb = new StringBuffer();
        int lvSize = this.rows.size();
        int i = 0;
        while (i < lvSize) {
            String lvRow = this.row2String(i);
            sb.append(lvRow);
            if (i < lvSize - 1 && !lvRow.endsWith("\r\n")) {
                sb.append("\r\n");
            }
            ++i;
        }
        return sb.toString();
    }

    public String getRowsWithColumnsAndColumnsNamesAsString() {
        StringBuffer sb = new StringBuffer();
        String lvColumnNames = this.getColumnNames();
        if (lvColumnNames.trim().length() > 0) {
            sb.append(lvColumnNames);
            sb.append("\r\n");
        }
        sb.append(this.getRowsWithColumnsAsString());
        return sb.toString();
    }

    public String getColumnNames() {
        StringBuffer sb = new StringBuffer();
        int lvSize = this.columnNames.size();
        int i = 0;
        while (i < lvSize) {
            sb.append(this.columnNames.get(i));
            if (i < lvSize - 1) {
                sb.append(this.getDelimiter());
            }
            ++i;
        }
        return sb.toString();
    }

    public String row2String(int pvRow) {
        StringBuffer sb = new StringBuffer();
        List lvColumn = (List)this.rows.get(pvRow);
        int lvSize = lvColumn.size();
        int i = 0;
        while (i < lvSize) {
            sb.append(lvColumn.get(i));
            if (i < lvSize - 1) {
                sb.append(this.getDelimiter());
            }
            ++i;
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getColumnNames()).append("\n");
        int i = 0;
        while (i < this.rows.size()) {
            sb.append(this.row2String(i)).append("\n");
            ++i;
        }
        return sb.toString();
    }

    public void validateAndRemoveEmptyRows() {
        Iterator it = this.rows.iterator();
        int i = -1;
        while (it.hasNext()) {
            ++i;
            List lvRow = (List)it.next();
            if (lvRow.size() == this.numberOfColumns) continue;
            if (lvRow.size() == 1 && lvRow.get(0).toString().trim().length() == 0) {
                it.remove();
                continue;
            }
            throw new IllegalStateException("Row: " + i + " - expected number of columns: " + this.numberOfColumns + " but was " + lvRow.size() + " --> " + lvRow);
        }
    }
}

